/* resource name code
   Marc Wolfgram    08Jan90
                    17Jun90 Started memory resident name code...


   Copyright 1990
   Simple Software Systems International, Inc.

   ALL RIGHTS RESERVED
*/
#include "genesys.h"
#include <types.h>
#include <ctype.h>
#include <stdio.h>
#include <memory.h>
#include <resources.h>
#include <usrlib.h>

extern int MasterID;
extern int ResFileID;

void shError(int, int);
int  toolerror(void);

int get_label_status;
int resTop = 39;
char nStr[32];
char tagName[256];

char    NameFmt[] = "R%0.4X";
char    TypeFmt[] = "rType $%0.4X";
char    ItemFmt[] = "%s%c%0.8lX";

struct res {
    word T;
    char *N, *R;
} res[] = { 0x8001, "ICON",     "Icon",
            0x8002, "PICTURE",  "Picture",
            0x8003, "CTLLST",   "Control List",
            0x8004, "CTLTMP",   "Control",
            0x8005, "C1INPUT",  "C1 Input String",
            0x8006, "PSTR",     "Pascal String",
            0x8007, "STRLST",   "String List",
            0x8008, "MENUBAR",  "Menu Bar",
            0x8009, "MENU",     "Menu",
            0x800a, "MENUITEM", "Menu Item",
            0x800b, "LETXTBOX", "LETextBox2 String",
            0x800c, "CTLPROC",  "Control Def Proc",
            0x800d, "CTLCOLOR", "Control Color",
            0x800e, "WPARAM1",  "Window",
            0x800f, "WPARAM2",  "Window (custom)",
            0x8010, "WCOLOR",   "Window Color",
            0x8011, "TXTBLK",   "Text Block",
            0x8012, "STYLEBLK", "Style Block",
            0x8013, "TSTART",   "Tool Table",
            0x8014, "RNAME",    "Resource Name",
            0x8015, "ALERT",    "Alert String",
            0x8016, "TXT",      "Text",
            0x8017, "CODE",     "Code Resource",
            0x8018, "CDEVCODE", "CDev",
            0x8019, "CDEVFLG",  "CDev Flag",
            0x801a, "TWORECTS", "Two Rects",
            0x801b, "FILETYPE", "File Type",
            0x801c, "LSTREF",   "List Ref",
            0x801d, "CSTR",     "C String",
            0x801e, "XCMD",     "XCmd",
            0x801f, "XFCN",     "XFcn",
            0x8020, "ERRSTR",   "Error String",
            0x8021, "KEYTBL",   "Key Trans Table",
            0x8022, "WSTR",     "W String",
            0x8023, "C1OUTPUT", "C1 Output String",
            0x8024, "SSOUND",   "Sound Sample",
            0x8025, "TERULER",  "TE Ruler",
            0x8026, "FSEQ",     "F Sequence",
            0x8027, "CURSOR",   "Cursor",
            0xc001, "RECTLST",  "Rect List"
};

char *get_name(Word rType, int kind)
{
    int i;

    for(i = resTop; i >= 0; i--)
        if (res[i].T == rType)
            return (kind ? res[i].N : res[i].R);

    if (kind)
        sprintf(nStr, NameFmt, rType);
    else
        sprintf(nStr, TypeFmt, rType);
    return nStr;
}

char *get_label(Word rType, long ID, int sub)
{
    char    *p;
    int     rDepth, fileID, i, j;
    long    nameID, cnt, offset;
    ResNameEntryPtr namePtr;
    ResNameRecHndl nameHndl;

    fileID = GetCurResourceFile();
    SetCurResourceFile(ResFileID);
    rDepth = SetResourceFileDepth(1);

    get_label_status = -1;
    tagName[0] = 0x00;
    nameID = 0x10000L + (long) rType;
    nameHndl = (ResNameRecHndl) LoadResource(0x8014, nameID);
    i = toolerror();
    SetCurResourceFile(fileID);
    rDepth = SetResourceFileDepth(rDepth);

    if (i == 0 && (**nameHndl).version == 1) {
        namePtr = &((**nameHndl).resNameEntries[0]);
        for (cnt = (**nameHndl).nameCount; cnt > 0L ; cnt--) {
            p = (char *) &(namePtr->resName);
            if (ID == (long) namePtr->namedResID) {
                for(i = 0, j = (int) *p; i < j; i++)
                    tagName[i] = (ispunct(*++p) && sub != 0) ? (char) sub : *p;
                tagName[i] = 0x00;
                break;
            }
            (long) namePtr += (*p + 5);
        }
        ReleaseResource(0, 0x8014, nameID);
    }

    if (tagName[0] == 0x00) {
        get_label_status = 0;
        sprintf(tagName, ItemFmt,
            get_name(rType, 1), (sub != 0) ? (char) sub : '_',  ID);
    }
    return tagName;
}
